<?php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\File;

class EnsureSetupCompleted
{
    public function handle($request, Closure $next)
    {
        if (!File::exists(base_path('.env')) || !env('APP_INSTALLED', false)) {
            if (!$request->is('setup')) {
                return redirect('/setup');
            }
        }
        return $next($request);
    }
}
?>