<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class SetupController extends Controller
{
    public function showSetupForm()
    {
        if (File::exists(base_path('.env')) && env('APP_INSTALLED', false)) {
            return redirect('/');
        }

        return view('setup');
    }

    public function processSetup(Request $request)
    {
        $validated = $request->validate([
            'api_key' => 'required|string',
            'subdomain' => 'required|string',
            'db_host' => 'required|string',
            'db_port' => 'required|integer',
            'db_database' => 'required|string',
            'db_username' => 'required|string',
            'db_password' => 'nullable|string',
        ]);

        $envContent = "
APP_NAME=CurrentRMS
APP_ENV=production
APP_KEY=
APP_DEBUG=false
APP_URL=" . url('/') . "

DB_CONNECTION=mysql
DB_HOST={$validated['db_host']}
DB_PORT={$validated['db_port']}
DB_DATABASE={$validated['db_database']}
DB_USERNAME={$validated['db_username']}
DB_PASSWORD={$validated['db_password']}

API_KEY={$validated['api_key']}
SUBDOMAIN={$validated['subdomain']}
APP_INSTALLED=true
";

        File::put(base_path('.env'), $envContent);
        \Artisan::call('key:generate');

        return redirect('/')->with('success', 'Setup completed successfully!');
    }
}
?>