<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class ApiController extends Controller
{
    public function fetchOpportunities()
    {
        $apiKey = env('API_KEY');
        $subdomain = env('SUBDOMAIN');
        $url = "https://$subdomain.current-rms.com/api/v1/opportunities";

        $response = Http::withHeaders([
            'X-AUTH-TOKEN' => $apiKey,
            'Accept' => 'application/json',
        ])->get($url);

        if ($response->failed()) {
            return response()->json(['error' => 'Failed to fetch opportunities.'], 500);
        }

        $opportunities = $response->json()['opportunities'] ?? [];
        return view('opportunities', ['opportunities' => $opportunities]);
    }
}
?>